<?php 
include ('includes/header.php');
$db = new SQLite3("a/.logs.db");

// Configurações de paginação
$limit = 500; 
$page = isset($_GET['page']) ? (int)$_GET['page'] : 1; 
$offset = ($page - 1) * $limit; 

// Consulta total
$total_res = $db->query("SELECT COUNT(*) as total FROM logs");
$total_row = $total_res->fetchArray();
$total_logs = $total_row['total'];

// Consulta registros
$res = $db->query("SELECT * FROM logs ORDER by id DESC LIMIT $limit OFFSET $offset");

// Erros
ini_set('display_errors', 1);
ini_set('display_startup_errors', 1);
error_reporting(E_ALL);

// Deletar único
if (isset($_GET['delete'])) {
    $id = (int)$_GET['delete'];
    $db->exec("DELETE FROM logs WHERE id = '$id'");
    echo '<script>window.location.replace("snoop.php");</script>';
    exit();
}

// Exclusão em massa
if (isset($_GET['delete_selected'])) {
    $ids_to_delete = isset($_GET['delete_check']) ? $_GET['delete_check'] : [];
    
    if (!empty($ids_to_delete)) {
        $chunk_size = 500; 
        $chunks = array_chunk($ids_to_delete, $chunk_size); 

        foreach ($chunks as $chunk) {
            $ids_string = implode(',', array_map('intval', $chunk)); 
            $db->exec("DELETE FROM logs WHERE id IN ($ids_string)"); 
        }
    } else {
        echo "<script>alert('Nenhum registro selecionado para exclusão.');</script>";
    }
    echo '<script>window.location.replace("snoop.php");</script>';
    exit();
}
?>

<style>
    @import url('https://fonts.googleapis.com/css2?family=Orbitron:wght@400;700&family=Poppins:wght@300;400;600&display=swap');

    :root {
        --neon-blue: #00d4ff;
        --dark-bg: #06090c;
        --card-glass: rgba(13, 18, 24, 0.95);
        --border-glass: rgba(0, 212, 255, 0.2);
    }

    /* Reset total de fundo branco */
    body, #wrapper, #content-wrapper, #content {
        background-color: var(--dark-bg) !important;
        color: #f8f9fc;
        font-family: 'Poppins', sans-serif;
    }

    .card-futuristic {
        background: var(--card-glass) !important;
        backdrop-filter: blur(15px);
        border: 1px solid var(--border-glass) !important;
        border-radius: 15px !important;
        box-shadow: 0 10px 30px rgba(0,0,0,0.5);
    }

    .card-header-futuristic {
        background: rgba(0, 212, 255, 0.03) !important;
        border-bottom: 1px solid var(--border-glass) !important;
        padding: 1.5rem !important;
    }

    .card-header-futuristic h1, .card-header-futuristic h6 {
        font-family: 'Orbitron', sans-serif;
        color: var(--neon-blue) !important;
        text-shadow: 0 0 10px var(--neon-blue);
        letter-spacing: 2px;
        margin: 0;
        text-transform: uppercase;
    }

    /* Tabela de Logs */
    .table-modern {
        color: #e0e0e0 !important;
        border-collapse: separate;
        border-spacing: 0 8px;
        width: 100%;
    }

    .table-modern thead th {
        border: none !important;
        color: var(--neon-blue) !important;
        text-transform: uppercase;
        font-size: 0.75rem;
        padding: 12px;
    }

    .table-modern tbody tr {
        background: rgba(255, 255, 255, 0.02);
        transition: 0.3s;
    }

    .table-modern tbody tr:hover {
        background: rgba(0, 212, 255, 0.08);
        transform: scale(1.002);
    }

    .table-modern td {
        border: none !important;
        padding: 12px !important;
        vertical-align: middle !important;
    }

    /* Checkbox neon */
    input[type="checkbox"] {
        accent-color: var(--neon-blue);
        cursor: pointer;
    }

    /* Botão Neon */
    .btn-neon-danger {
        background: transparent;
        border: 1px solid #ff3e3e;
        color: #ff3e3e !important;
        font-family: 'Orbitron', sans-serif;
        padding: 8px 20px;
        border-radius: 8px;
        transition: 0.4s;
        text-transform: uppercase;
        font-size: 0.8rem;
    }

    .btn-neon-danger:hover {
        background: #ff3e3e;
        color: #fff !important;
        box-shadow: 0 0 15px rgba(255, 62, 62, 0.4);
    }

    /* Paginação */
    .pagination-futuristic {
        display: flex;
        justify-content: center;
        list-style: none;
        padding: 20px 0;
        gap: 5px;
    }

    .pagination-futuristic .page-link {
        background: rgba(255, 255, 255, 0.05);
        border: 1px solid var(--border-glass);
        color: #fff;
        border-radius: 5px;
        padding: 8px 15px;
        text-decoration: none;
        transition: 0.3s;
    }

    .pagination-futuristic .active .page-link {
        border-color: var(--neon-blue);
        color: var(--neon-blue);
        background: rgba(0, 212, 255, 0.1);
        box-shadow: 0 0 10px rgba(0, 212, 255, 0.2);
    }

    .pagination-futuristic .page-link:hover:not(.active) {
        background: rgba(0, 212, 255, 0.05);
        border-color: var(--neon-blue);
    }
</style>

<div class="container-fluid pt-4 px-5">
    <div class="card card-futuristic shadow mb-4">
        <div class="card-header-futuristic d-flex justify-content-between align-items-center">
            <h1><i class="fas fa-search-location mr-2"></i> Logs</h1>
            <span class="badge" style="border: 1px solid var(--neon-blue); color: var(--neon-blue);">Total: <?php echo $total_logs; ?></span>
        </div>
        
        <div class="card-body">
            <form method="get">
                <div class="mb-4 text-right">
                    <button type="submit" class="btn-neon-danger" name="delete_selected">
                        <i class="fas fa-trash-alt mr-2"></i>Excluir Selecionados
                    </button>
                </div>

                <div class="table-responsive">
                    <table class="table table-modern">
                        <thead>
                            <tr>
                                <th><input type="checkbox" id="selecionarTodos"></th>
                                <th>ID</th>
                                <th>Data / Hora</th>
                                <th>Endereço IP</th>
                                <th class="text-center">Deletar</th>
                            </tr>
                        </thead>
                        <tbody>
                            <?php while ($row = $res->fetchArray()) { ?>
                                <tr>
                                    <td><input type="checkbox" class="checkbox" name="delete_check[]" value="<?php echo $row['id']; ?>"></td>
                                    <td style="color: var(--neon-blue); font-family: 'Orbitron'; font-size: 0.8rem;"><?=$row['id'] ?></td>
                                    <td><span style="opacity: 0.8;"><?=$row['date'] ?></span></td>
                                    <td><code><?=$row['ipaddress'] ?></code></td>
                                    <td class="text-center">
                                        <a href="snoop.php?delete=<?php echo $row['id']; ?>" title="Excluir Registro">
                                            <i class="fas fa-trash" style="color: #ff3e3e; text-shadow: 0 0 5px #ff3e3e;"></i>
                                        </a>
                                    </td>
                                </tr>
                            <?php } ?>
                        </tbody>
                    </table>
                </div>
            </form>

            <nav>
                <ul class="pagination-futuristic">
                    <?php
                    $total_pages = ceil($total_logs / $limit);
                    // Mostrar apenas algumas páginas se houver muitas para não quebrar o layout
                    for ($i = 1; $i <= $total_pages; $i++) {
                        $activeClass = ($i == $page) ? "active" : "";
                        echo "<li class='$activeClass'><a class='page-link' href='snoop.php?page=$i'>$i</a></li>";
                    }
                    ?>
                </ul>
            </nav>
        </div>
    </div>
</div>

<?php include ('includes/footer.php');?>

<script>
    // Selecionar todos os checkboxes
    document.getElementById('selecionarTodos').addEventListener('change', function() {
        var checkboxes = document.getElementsByClassName('checkbox');
        for (var i = 0; i < checkboxes.length; i++) {
            checkboxes[i].checked = this.checked;
        }
    });
</script>