<?php
$file_path = __DIR__ . '/a/revenda_mensagem.json';

// Se não existir, cria com padrão
if (!file_exists($file_path)) {
    file_put_contents($file_path, json_encode(['title' => '', 'content' => ''], JSON_UNESCAPED_UNICODE | JSON_PRETTY_PRINT));
}

$file_content = file_get_contents($file_path);
$data_array = json_decode($file_content, true);
if (!is_array($data_array)) $data_array = ['title' => '', 'content' => ''];

// Mensagem de sucesso (HTML controlado por você)
$flash_message = '<div class="alert-neon-black" id="flash-msg"><i class="fas fa-check-circle"></i> ALERTA ATUALIZADO COM SUCESSO</div>';

if (isset($_POST['text'])) {
    $new_data = [
        'title' => $_POST['title'] ?? '',
        'content' => $_POST['content'] ?? ''
    ];

    $updated_content = json_encode($new_data, JSON_UNESCAPED_UNICODE | JSON_PRETTY_PRINT);
    file_put_contents($file_path, $updated_content);

    header('Location: revenda_mensagem.php?m=1');
    exit();
}

$title = $data_array['title'] ?? '';
$content = $data_array['content'] ?? '';

include 'includes/header.php';
?>

<style>
:root {
    --neon-blue: #00d4ff;
    --dark-bg: #06090c;
    --pure-black: #000000;
    --border-glass: rgba(0, 212, 255, 0.2);
}
body { 
    background-color: var(--dark-bg) !important; 
    color: #f8f9fc;
    font-family: 'Poppins', sans-serif;
}
.alert-neon-black {
    background-color: var(--pure-black) !important;
    border: 2px solid var(--neon-blue);
    color: #ffffff !important;
    padding: 20px;
    border-radius: 12px;
    margin-bottom: 30px;
    text-align: center;
    font-family: 'Orbitron', sans-serif;
    font-weight: bold;
    letter-spacing: 2px;
    box-shadow: 0 0 15px rgba(0, 212, 255, 0.4), inset 0 0 10px rgba(0, 212, 255, 0.2);
    text-shadow: 0 0 10px rgba(255, 255, 255, 0.8), 0 0 20px var(--neon-blue);
    animation: pulseNeon 2s infinite alternate;
}
@keyframes pulseNeon {
    from { box-shadow: 0 0 10px rgba(0, 212, 255, 0.4); }
    to { box-shadow: 0 0 25px rgba(0, 212, 255, 0.7); }
}
.page-title {
    font-family: 'Orbitron', sans-serif;
    color: #fff;
    margin-bottom: 25px;
    font-size: 1.5rem;
}
.card-futuristic {
    background: rgba(13, 18, 24, 0.95) !important;
    backdrop-filter: blur(15px);
    border: 1px solid var(--border-glass) !important;
    border-radius: 15px !important;
    box-shadow: 0 10px 30px rgba(0,0,0,0.5);
    max-width: 650px;
}
.card-header-futuristic {
    background: rgba(0, 212, 255, 0.05) !important;
    border-bottom: 1px solid var(--border-glass) !important;
    padding: 1.2rem !important;
}
.card-header-futuristic h6 {
    font-family: 'Orbitron', sans-serif;
    color: var(--neon-blue) !important;
    text-shadow: 0 0 5px var(--neon-blue);
    margin: 0;
}
.form-control-futuristic {
    background: rgba(0, 0, 0, 0.6) !important;
    border: 1px solid var(--border-glass) !important;
    color: #fff !important;
    border-radius: 8px;
    padding: 12px;
}
.form-control-futuristic:focus {
    border-color: var(--neon-blue) !important;
    box-shadow: 0 0 10px rgba(0, 212, 255, 0.3);
}
.btn-neon-update {
    background: transparent;
    border: 1px solid var(--neon-blue);
    color: var(--neon-blue);
    font-family: 'Orbitron', sans-serif;
    padding: 15px;
    border-radius: 8px;
    width: 100%;
    transition: 0.4s;
    cursor: pointer;
}
.btn-neon-update:hover {
    background: var(--neon-blue);
    color: #000;
    box-shadow: 0 0 20px var(--neon-blue);
}
</style>

<div class="container-fluid pt-4 px-5">
    <?php if (isset($_GET['m'])): ?>
        <div class="alert-neon-black" id="flash-msg"><i class="fas fa-check-circle"></i> ALERTA ATUALIZADO COM SUCESSO</div>
    <?php endif; ?>

    <h1 class="page-title"><i class="fas fa-broadcast-tower mr-2"></i> Terminal de Comunicados</h1>

    <div class="row">
        <div class="col-lg-7">
            <div class="card card-futuristic">
                <div class="card-header-futuristic">
                    <h6><i class="fa fa-bullhorn mr-2"></i> EDITAR ALERTA PARA OS USUÁRIOS</h6>
                </div>
                <div class="card-body p-4">
                    <form method="post">
                        <div class="form-group mb-4">
                            <label style="color:var(--neon-blue); font-size: 11px; text-transform: uppercase;">Título do Alerta</label>
                            <input type="text" class="form-control form-control-futuristic" name="title" value="<?= htmlspecialchars($title) ?>" required>
                        </div>

                        <div class="form-group mb-4">
                            <label style="color:var(--neon-blue); font-size: 11px; text-transform: uppercase;">Mensagem de Alerta</label>
                            <textarea class="form-control form-control-futuristic" rows="5" name="content" required><?= htmlspecialchars($content) ?></textarea>
                        </div>

                        <button type="submit" name="text" class="btn btn-neon-update">
                            <i class="fas fa-paper-plane mr-2"></i> ATUALIZAR ALERTA
                        </button>
                    </form>
                </div>
            </div>
        </div>
    </div>
</div>

<script>
setTimeout(function() {
    var msg = document.getElementById('flash-msg');
    if(msg) {
        msg.style.transition = "all 0.8s";
        msg.style.opacity = "0";
        msg.style.transform = "scale(0.9)";
        setTimeout(function() { msg.remove(); }, 800);
    }
}, 5000);
</script>

<?php include 'includes/footer.php'; ?>
