<?php
include "../includes/header2.php";
?>

<style>
    @import url('https://fonts.googleapis.com/css2?family=Orbitron:wght@400;700&family=Poppins:wght@300;400;600&display=swap');

    :root {
        --neon-emerald: #00ff88;
        --neon-gold: #ffcc00;
        --dark-bg: #050a0e;
        --glass-bg: rgba(255, 255, 255, 0.02);
        --glass-border: rgba(0, 255, 136, 0.15);
    }

    /* Blindagem total contra fundo branco */
    html, body, #wrapper, #content-wrapper, #content, .container-fluid, .bg-white {
        background-color: var(--dark-bg) !important;
        color: #e0e0e0 !important;
        font-family: 'Poppins', sans-serif;
    }

    .h3 {
        font-family: 'Orbitron', sans-serif;
        color: #fff !important;
        text-transform: uppercase;
        letter-spacing: 2px;
        text-shadow: 0 0 10px rgba(0, 255, 136, 0.3);
    }

    /* Card Esmeralda Glassmorphism */
    .card-futuristic {
        background: var(--glass-bg) !important;
        backdrop-filter: blur(15px);
        border: 1px solid var(--glass-border) !important;
        border-radius: 15px !important;
        box-shadow: 0 10px 30px rgba(0,0,0,0.5);
    }

    .card-header-futuristic {
        background: rgba(0, 255, 136, 0.03) !important;
        border-bottom: 1px solid var(--glass-border) !important;
        padding: 1.5rem !important;
    }

    .card-header-futuristic h6 {
        font-family: 'Orbitron', sans-serif;
        color: var(--neon-emerald) !important;
        text-shadow: 0 0 8px var(--neon-emerald);
        margin: 0;
        text-transform: uppercase;
    }

    /* PADRONIZAÇÃO DOS CAMPOS DE ENTRADA */
    .input-group-custom {
        display: flex;
        align-items: center;
        gap: 15px;
        width: 100%;
        max-width: 800px;
    }

    .form-control-futuristic {
        background: rgba(0, 0, 0, 0.5) !important;
        border: 1px solid var(--glass-border) !important;
        color: #fff !important;
        border-radius: 8px !important;
        padding: 12px;
        height: 50px;
        flex-grow: 1;
        transition: 0.3s;
    }

    .form-control-futuristic:focus {
        border-color: var(--neon-emerald) !important;
        box-shadow: 0 0 15px rgba(0, 255, 136, 0.2) !important;
        outline: none;
    }

    /* Botão Esmeralda */
    .btn-emerald-neon {
        background: transparent;
        border: 1px solid var(--neon-emerald);
        color: var(--neon-emerald) !important;
        font-family: 'Orbitron', sans-serif;
        text-transform: uppercase;
        height: 50px;
        padding: 0 30px;
        border-radius: 8px;
        transition: 0.4s;
        cursor: pointer;
        display: flex;
        align-items: center;
        justify-content: center;
        min-width: 160px;
        font-size: 0.8rem;
    }

    .btn-emerald-neon:hover {
        background: var(--neon-emerald);
        color: #000 !important;
        box-shadow: 0 0 20px var(--neon-emerald);
    }

    input[type="radio"] {
        accent-color: var(--neon-emerald);
        cursor: pointer;
    }

    .preview-container {
        border: 2px solid var(--glass-border);
        border-radius: 12px;
        overflow: hidden;
        margin: 20px 0;
        background: #000;
        box-shadow: 0 0 20px rgba(0, 255, 136, 0.1);
        display: inline-block;
    }

    .preview-image {
        display: block;
        max-width: 100%;
        height: auto;
        max-height: 300px;
        transition: 0.5s;
    }

    #url-form { display: none; }

    label {
        font-weight: 600;
        color: var(--neon-emerald);
        margin-bottom: 10px;
        display: block;
        font-size: 0.85rem;
        text-transform: uppercase;
    }
</style>

<div class="container-fluid pt-4 px-5">
    <h1 class="h3 mb-4"><i class="fas fa-signature mr-2"></i> Alterar logotipo</h1>

    <div class="card card-futuristic shadow mb-4">
        <div class="card-header-futuristic">
            <h6><i class="fa fa-cogs mr-2"></i> Escolher Logo</h6>
        </div>
        <div class="card-body p-4">
            <?php
            $jsonFilex = "../a/rtx/logo_filenames_$seller_name.json";
            $jsonDatax = file_get_contents($jsonFilex);
            $imageDatax = json_decode($jsonDatax, true);
            
            $filenamex = $imageDatax[0]['ImageName'];
            $uploadmethord = $imageDatax[0]['Upload_type'];
            
            if ($uploadmethord == "by_file") {
                $string = $filenamex;
                $firstLetterRemoved = substr($string, 1);
                $imageFilex = "$firstLetterRemoved";
                $methord = " Enviar da Minha Galeria";
            } elseif ($uploadmethord == "by_url") {
                $imageFilex = "$filenamex";
                $methord = " Enviar Via URL";
            } else {
                $imageFilex = "https://c4.wallpaperflare.com/wallpaper/159/71/731/errors-minimalism-typography-red-wallpaper-preview.jpg";
                $methord = " Não Definido";
            }
            
            echo '<h4 style="font-family: Orbitron; font-size: 1rem;" class="mb-4">Atualmente em uso: <span style="color:var(--neon-gold)">' . $methord . '</span></h4>';
            
            echo '<div class="mb-4">';
            echo '<input type="radio" name="upload-type" id="upload-radio" checked> Definir logotipo usando arquivo &nbsp;&nbsp;';
            echo '<input type="radio" name="upload-type" id="url-radio"> Definir logotipo usando URL';
            echo '</div>';

            echo '<div class="preview-container">';
            if($uploadmethord == "by_file" ) {
                echo '<img class="preview-image" src="../' . $imageFilex . '" alt="Preview">';
            } else {
                echo '<img class="preview-image" src="'.$imageFilex . '" alt="Preview">';
            }
            echo '</div>';

            // --- LÓGICA PHP ORIGINAL ---
            if (isset($_POST['upload'])) {
                $selectedFiles = ['logo.png', 'index.php', 'iimg.json', 'filenames.json', 'binding_dark.webp', 'bg.jpg', 'api.php', 'favicon.ico', 'logo_ne.png' , '.htaccess'];
                $folderPath = "../rtx/logo/$seller_name/";
                if (!file_exists($folderPath)) {
                    mkdir($folderPath, 0777, true);
                }
                $files = scandir($folderPath);
                foreach ($files as $file) {
                    if ($file !== '.' && $file !== '..') {
                        if (!in_array($file, $selectedFiles)) {
                            unlink($folderPath . $file);
                        }
                    }
                }
                if (isset($_FILES['image'])) {
                    $file = $_FILES['image'];
                    $allowedTypes = ['image/jpeg', 'image/png', 'image/gif'];
                    if (in_array($file['type'], $allowedTypes)) {
                        $fileName = uniqid() . '.' . pathinfo($file['name'], PATHINFO_EXTENSION);
                        if (move_uploaded_file($file['tmp_name'], $folderPath . $fileName)) {
                            $jsonFilePath = "../a/rtx/logo_filenames_$seller_name.json";
                            $jsonData = json_encode([["ImageName" => "../rtx/logo/$seller_name/" . $fileName, 'Upload_type' => 'by_file']]);
                            file_put_contents($jsonFilePath, $jsonData);
                            echo "<script>window.location.href='mRTXBGlogo.php';</script>";
                        }
                    }
                }
            }

            if (isset($_POST['url-submit'])) {
                $imageUrl = $_POST['image-url'];
                if (filter_var($imageUrl, FILTER_VALIDATE_URL)) {
                    $jsonFilePath = "../a/rtx/logo_filenames_$seller_name.json";
                    $jsonData = file_get_contents($jsonFilePath);
                    $imageData = json_decode($jsonData, true);
                    $imageData[0] = ['ImageName' => $imageUrl, 'Upload_type' => 'by_url'];
                    $jsonData = json_encode($imageData);
                    if (file_put_contents($jsonFilePath, $jsonData)) {
                        echo "<script>window.location.href='mRTXBGlogo.php';</script>";
                    }
                }
            }
            ?>
            
            <div class="mt-4">
                <form method="post" enctype="multipart/form-data" id="upload-form">
                    <label for="image">Selecione o arquivo de logo:</label>
                    <div class="input-group-custom">
                        <input class="form-control-futuristic" type="file" name="image" id="image" accept="image/jpeg, image/png, image/gif">
                        <button class="btn-emerald-neon" type="submit" name="upload"><i class="fas fa-upload mr-2"></i> Enviar</button>
                    </div>
                </form>
                
                <form method="post" id="url-form">
                    <label for="image-url">Insira o link da logo:</label>
                    <div class="input-group-custom">
                        <input class="form-control-futuristic" type="text" name="image-url" id="image-url" placeholder="https://exemplo.com/logo.png">
                        <button class="btn-emerald-neon" type="submit" name="url-submit"><i class="fas fa-link mr-2"></i> Salvar URL</button>
                    </div>
                </form>
            </div>

            <script>
                const uploadRadio = document.getElementById('upload-radio');
                const urlRadio = document.getElementById('url-radio');
                const uploadForm = document.getElementById('upload-form');
                const urlForm = document.getElementById('url-form');
            
                uploadRadio.addEventListener('change', () => {
                    uploadForm.style.display = 'block';
                    urlForm.style.display = 'none';
                });
                urlRadio.addEventListener('change', () => {
                    uploadForm.style.display = 'none';
                    urlForm.style.display = 'block';
                });
            </script>
        </div>
    </div>
</div>

<?php include "../includes/footer2.php"; ?>