<?php
include "../includes/header2.php";
?>

<style>
    @import url('https://fonts.googleapis.com/css2?family=Orbitron:wght@400;700&family=Poppins:wght@300;400;600&display=swap');

    :root {
        --neon-emerald: #00ff88;
        --neon-gold: #ffcc00;
        --dark-bg: #050a0e;
        --glass-bg: rgba(255, 255, 255, 0.02);
        --glass-border: rgba(0, 255, 136, 0.15);
    }

    /* Blindagem total contra fundo branco */
    html, body, #wrapper, #content-wrapper, #content, .container-fluid, .bg-white {
        background-color: var(--dark-bg) !important;
        color: #e0e0e0 !important;
        font-family: 'Poppins', sans-serif;
    }

    .h3 {
        font-family: 'Orbitron', sans-serif;
        color: #fff !important;
        text-transform: uppercase;
        letter-spacing: 2px;
        text-shadow: 0 0 10px rgba(0, 255, 136, 0.3);
    }

    /* Card Esmeralda Glassmorphism */
    .card-futuristic {
        background: var(--glass-bg) !important;
        backdrop-filter: blur(15px);
        border: 1px solid var(--glass-border) !important;
        border-radius: 15px !important;
        box-shadow: 0 10px 30px rgba(0,0,0,0.5);
    }

    .card-header-futuristic {
        background: rgba(0, 255, 136, 0.03) !important;
        border-bottom: 1px solid var(--glass-border) !important;
        padding: 1.5rem !important;
    }

    .card-header-futuristic h6 {
        font-family: 'Orbitron', sans-serif;
        color: var(--neon-emerald) !important;
        text-shadow: 0 0 8px var(--neon-emerald);
        margin: 0;
        text-transform: uppercase;
    }

    /* Estilo do Select e Botão */
    .form-control-futuristic {
        background: rgba(0, 0, 0, 0.5) !important;
        border: 1px solid var(--glass-border) !important;
        color: #fff !important;
        border-radius: 8px !important;
        padding: 12px;
        height: 50px;
        font-family: 'Orbitron', sans-serif;
        min-width: 250px;
    }

    .btn-emerald-neon {
        background: transparent;
        border: 1px solid var(--neon-emerald);
        color: var(--neon-emerald) !important;
        font-family: 'Orbitron', sans-serif;
        text-transform: uppercase;
        height: 50px;
        padding: 0 30px;
        border-radius: 8px;
        transition: 0.4s;
        cursor: pointer;
        font-size: 0.8rem;
    }

    .btn-emerald-neon:hover {
        background: var(--neon-emerald);
        color: #000 !important;
        box-shadow: 0 0 20px var(--neon-emerald);
    }

    /* Galeria de Temas */
    .image-row {
        display: grid;
        grid-template-columns: repeat(auto-fit, minmax(300px, 1fr));
        gap: 25px;
        margin-top: 30px;
    }

    .theme-card {
        background: rgba(0, 0, 0, 0.3);
        border: 1px solid var(--glass-border);
        border-radius: 12px;
        padding: 15px;
        text-align: center;
        transition: 0.3s;
    }

    .theme-card:hover {
        border-color: var(--neon-emerald);
        transform: translateY(-5px);
        box-shadow: 0 5px 15px rgba(0, 255, 136, 0.1);
    }

    .theme-card img {
        border-radius: 8px;
        margin-bottom: 15px;
        width: 100%;
        height: auto;
        border: 1px solid rgba(255,255,255,0.05);
    }

    .theme-card p {
        font-family: 'Orbitron', sans-serif;
        color: var(--neon-emerald);
        font-size: 0.9rem;
        margin: 0;
        letter-spacing: 1px;
    }

    .current-label {
        font-family: 'Orbitron', sans-serif;
        color: var(--neon-gold);
        text-align: center;
        margin: 20px 0;
        font-size: 1.1rem;
    }
</style>

<div class="container-fluid pt-4 px-5">
    <h1 class="h3 mb-4">Temas</h1>

    <div class="card card-futuristic shadow mb-4">
        <div class="card-header-futuristic">
            <h6><i class="fa fa-cogs mr-2"></i> Escolher Tema</h6>
        </div>
        <div class="card-body">

        <?php
            // LÓGICA ORIGINAL: Processamento do POST
            if ($_SERVER['REQUEST_METHOD'] === 'POST') {
                $selectedOption = $_POST['options'];
                echo "<div style='color:var(--neon-emerald); text-align:center; font-family:Orbitron; margin-bottom:15px;'>Você selecionou: " . $selectedOption . "</div>";

                $jsonData = file_get_contents("../a/rtx/Setting_$seller_name.json");
                $data = json_decode($jsonData, true);

                $data[0]["RTXSetting"] = "mLayout";
                $data[0]["PanalData"] = $selectedOption;

                $jsonData = json_encode($data, JSON_PRETTY_PRINT);
                file_put_contents("../a/rtx/Setting_$seller_name.json", $jsonData);
            }

            // LÓGICA ORIGINAL: Leitura do Tema Atual
            $jsonData = file_get_contents("../a/rtx/Setting_$seller_name.json");
            $data = json_decode($jsonData, true);
            $current_layout = $data[0]["PanalData"];
        ?>

        <form method="post" action="<?php echo $_SERVER['PHP_SELF']; ?>" class="mb-4">
            <div class="d-flex flex-wrap justify-content-center align-items-center gap-3">
                <select name="options" id="options" class="form-control-futuristic">
                    <option value="theme_d" <?php if($current_layout == "theme_d") echo "selected"; ?>>Tema 1</option>
                    <option value="theme_2" <?php if($current_layout == "theme_2") echo "selected"; ?>>Tema 2</option>
                    <option value="theme_3" <?php if($current_layout == "theme_3") echo "selected"; ?>>Tema 3</option>
                    <option value="theme_5" <?php if($current_layout == "theme_5") echo "selected"; ?>>Tema 4</option>
                </select>
                <button type="submit" class="btn-emerald-neon">
                    <i class="fas fa-sync-alt mr-2"></i> Alterar Tema
                </button>
            </div>
        </form>

        <div class="current-label">
            TEMA ATUAL: <span style="text-shadow: 0 0 5px var(--neon-gold);"><?php echo strtoupper($current_layout); ?></span>
        </div>

        <div class="image-row">
            <div class="theme-card">
                <p>TEMA 1</p>
                <img src="../rtx/layout/d.png" alt="theme_d">
            </div>

            <div class="theme-card">
                <p>TEMA 2</p>
                <img src="../rtx/layout/2.png" alt="theme_2">
            </div>   

            <div class="theme-card">
                <p>TEMA 3</p>
                <img src="../rtx/layout/3.png" alt="theme_3">
            </div>

            <div class="theme-card">
                <p>TEMA 4</p>
                <img src="../rtx/layout/5.png" alt="theme_5">
            </div>
        </div>

        </div>
    </div>
</div>

<?php
include "../includes/footer2.php";
?>