<?php
include "../includes/header2.php";
?>

<style>
    @import url('https://fonts.googleapis.com/css2?family=Orbitron:wght@400;700&family=Poppins:wght@300;400;600&display=swap');

    :root {
        --neon-emerald: #00ff88;
        --neon-gold: #ffcc00;
        --dark-bg: #050a0e;
        --glass-bg: rgba(255, 255, 255, 0.02);
        --glass-border: rgba(0, 255, 136, 0.15);
    }

    /* Blindagem total contra fundo branco */
    html, body, #wrapper, #content-wrapper, #content, .container-fluid, .bg-white {
        background-color: var(--dark-bg) !important;
        color: #e0e0e0 !important;
        font-family: 'Poppins', sans-serif;
    }

    .h3 {
        font-family: 'Orbitron', sans-serif;
        color: #fff !important;
        text-transform: uppercase;
        letter-spacing: 2px;
        text-shadow: 0 0 10px rgba(0, 255, 136, 0.3);
    }

    .card-futuristic {
        background: var(--glass-bg) !important;
        backdrop-filter: blur(15px);
        border: 1px solid var(--glass-border) !important;
        border-radius: 15px !important;
        box-shadow: 0 10px 30px rgba(0,0,0,0.5);
    }

    .card-header-futuristic {
        background: rgba(0, 212, 255, 0.03) !important;
        border-bottom: 1px solid var(--glass-border) !important;
        padding: 1.5rem !important;
    }

    .card-header-futuristic h6 {
        font-family: 'Orbitron', sans-serif;
        color: var(--neon-emerald) !important;
        text-shadow: 0 0 8px var(--neon-emerald);
        margin: 0;
        text-transform: uppercase;
    }

    /* PADRONIZAÇÃO DOS CAMPOS */
    .input-group-custom {
        display: flex;
        align-items: center;
        gap: 15px;
        width: 100%;
        max-width: 800px;
    }

    .form-control-futuristic {
        background: rgba(0, 0, 0, 0.5) !important;
        border: 1px solid var(--glass-border) !important;
        color: #fff !important;
        border-radius: 8px !important;
        padding: 12px;
        height: 50px;
        flex-grow: 1;
    }

    .btn-emerald-neon {
        background: transparent;
        border: 1px solid var(--neon-emerald);
        color: var(--neon-emerald) !important;
        font-family: 'Orbitron', sans-serif;
        text-transform: uppercase;
        height: 50px;
        padding: 0 30px;
        border-radius: 8px;
        transition: 0.4s;
        cursor: pointer;
        display: flex;
        align-items: center;
        justify-content: center;
        min-width: 160px;
        font-size: 0.8rem;
    }

    .btn-emerald-neon:hover {
        background: var(--neon-emerald);
        color: #000 !important;
        box-shadow: 0 0 20px var(--neon-emerald);
    }

    input[type="radio"] { accent-color: var(--neon-emerald); cursor: pointer; }

    .preview-container {
        border: 2px solid var(--glass-border);
        border-radius: 12px;
        overflow: hidden;
        margin: 20px 0;
        background: #000;
        box-shadow: 0 0 20px rgba(0, 255, 136, 0.1);
        display: inline-block;
    }

    .preview-image { display: block; max-width: 100%; height: auto; max-height: 300px; }

    #url-form { display: none; }

    label { font-weight: 600; color: var(--neon-emerald); margin-bottom: 10px; display: block; text-transform: uppercase; font-size: 0.8rem; }
</style>

<div class="container-fluid pt-4 px-5">
    <h1 class="h3 mb-4"> Image Background</h1>

    <div class="card card-futuristic shadow mb-4">
        <div class="card-header-futuristic">
            <h6><i class="fa fa-cogs mr-2"></i> Escolher Banner</h6>
        </div>
        <div class="card-body p-4">
            <?php
            $jsonFilex = "../a/rtx/image_filenames_$seller_name.json";
            $jsonDatax = file_get_contents($jsonFilex);
            $imageDatax = json_decode($jsonDatax, true);
            $filenamex = $imageDatax[0]['ImageName'];
            $uploadmethord = $imageDatax[0]['Upload_type'];
            
            if ($uploadmethord == "by_file") {
                $string = $filenamex;
                $firstLetterRemoved = substr($string, 1);
                $imageFilex = "$firstLetterRemoved";
                $methord = " Upload Method";
            } elseif ($uploadmethord == "by_url") {
                $imageFilex = "$filenamex";
                $methord = " URL Method";
            } else {
                $imageFilex = "https://c4.wallpaperflare.com/wallpaper/159/71/731/errors-minimalism-typography-red-wallpaper-preview.jpg";
                $methord = "";
            }
            
            echo '<h3 style="font-family: Orbitron; font-size: 1.1rem; margin-bottom: 20px;">Atualmente em uso: <span style="color:var(--neon-gold)">' . $methord . '</span></h3>';
            echo '<div class="mb-4">';
            echo '<input type="radio" name="upload-type" id="upload-radio" checked> Definir plano de fundo usando arquivo &nbsp;&nbsp;';
            echo '<input type="radio" name="upload-type" id="url-radio"> Definir plano de fundo usando URL';
            echo '</div>';

            echo '<div class="preview-container">';
            if($uploadmethord == "by_file" ) {
                echo '<img class="preview-image" src="../' . $imageFilex . '" alt="Uploaded Image">';
            } else {
                echo '<img class="preview-image" src="'.$imageFilex . '" alt="Uploaded Image">';
            }
            echo '</div>';

            // --- LÓGICA PHP ORIGINAL INTEGRAL ---
            if (isset($_POST['upload'])) {
                $selectedFiles = ['logo.png', 'index.php', 'iimg.json', 'filenames.json', 'binding_dark.webp', 'bg.jpg', 'api.php', 'favicon.ico', 'logo_ne.png' , '.htaccess'];
                $folderPath = "../rtx/Img/$seller_name/";
                if (!file_exists($folderPath)) {
                    mkdir($folderPath, 0777, true);
                }
                $files = scandir($folderPath);
                foreach ($files as $file) {
                    if ($file !== '.' && $file !== '..') {
                        if (!in_array($file, $selectedFiles)) {
                            unlink($folderPath . $file);
                        }
                    }
                }
                if (isset($_FILES['image'])) {
                    $file = $_FILES['image'];
                    $fileType = $file['type'];
                    $fileTemp = $file['tmp_name'];
                    $allowedTypes = ['image/jpeg', 'image/png', 'image/gif'];
                    if (in_array($fileType, $allowedTypes)) {
                        $uploadPath = "../rtx/Img/$seller_name/";
                        $fileName = uniqid() . '.' . pathinfo($file['name'], PATHINFO_EXTENSION);
                        $destination = $uploadPath . $fileName;
                        if (move_uploaded_file($fileTemp, $destination)) {
                            $jsonFilePath = "../a/rtx/image_filenames_$seller_name.json";
                            $jsonData = json_encode([["ImageName" => "../rtx/Img/$seller_name/" . $fileName, 'Upload_type' => 'by_file']]);
                            file_put_contents($jsonFilePath, $jsonData);
                            echo "<script>window.location.href='mRTXBGImage.php';</script>"; // REDIRECIONAMENTO ORIGINAL
                        }
                    }
                }
            }

            if (isset($_POST['url-submit'])) {
                $imageUrl = $_POST['image-url'];
                if (filter_var($imageUrl, FILTER_VALIDATE_URL)) {
                    $jsonFilePath = "../a/rtx/image_filenames_$seller_name.json";
                    $jsonData = file_get_contents($jsonFilePath);
                    $imageData = json_decode($jsonData, true);
                    $imageData[0] = ['ImageName' => $imageUrl, 'Upload_type' => 'by_url'];
                    $jsonData = json_encode($imageData);
                    if (file_put_contents($jsonFilePath, $jsonData)) {
                        echo "<script>window.location.href='mRTXBGImage.php';</script>"; // REDIRECIONAMENTO ORIGINAL
                    }
                }
            }
            ?>
            
            <div class="mt-4">
                <form method="post" enctype="multipart/form-data" id="upload-form">
                    <label for="image">Selecione uma imagem para carregar:</label>
                    <div class="input-group-custom">
                        <input class="form-control-futuristic" type="file" name="image" id="image" accept="image/jpeg, image/png, image/gif">
                        <button class="btn-emerald-neon" type="submit" name="upload">Upload</button>
                    </div>
                </form>
                
                <form method="post" id="url-form">
                    <label for="image-url">Selecione um URL de imagem:</label>
                    <div class="input-group-custom">
                        <input class="form-control-futuristic" type="text" name="image-url" id="image-url" placeholder="https://example.com/image.jpg">
                        <button class="btn-emerald-neon" type="submit" name="url-submit">Enviar URL</button>
                    </div>
                </form>
            </div>

            <script>
                const uploadRadio = document.getElementById('upload-radio');
                const urlRadio = document.getElementById('url-radio');
                const uploadForm = document.getElementById('upload-form');
                const urlForm = document.getElementById('url-form');
            
                uploadRadio.addEventListener('change', () => {
                    uploadForm.style.display = 'block';
                    urlForm.style.display = 'none';
                });
                urlRadio.addEventListener('change', () => {
                    uploadForm.style.display = 'none';
                    urlForm.style.display = 'block';
                });
            </script>
        </div>
    </div>
</div>

<?php include "../includes/footer2.php"; ?>